	function [vlb, vub, h0, hlb, hub] = BOUNDING_BOX_FIR(N, W0, delta, ind, val)
	
	% 	Function that determits upper and lower bounds of 
	%	the coefficients for a linear-phase FIR filter of
	%	type I or II.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 			Per Loewenborg 2001-10-09
	% 	Modified by: 	 	LW 2001-12-02, TS 018-12-12
	% 	Copyright:			by authors - not released for commercial use
	% 	Version:			1  
	% 	Known bugs:		
	% 	Report bugs to:		Wanhammar@gmail.com
	
	
	% Use for new versiosn of MATLAB inprog and lp for older. Set New = 1
	
	New = 1;
	% 	vub and vlb are the upper and lower bounds of the 
	%	coefficients in the impulse response, h.
	% 
	% 	N, W0 and delta are order, passband and stopband 
	%	edges and ripples.
	
	% For type 1: hmax(N/2+1-m) = vub(m) m = 2,...,N/2+1
	%             hmin(N/2+1-m) = vlb(m) m = 2,...,N/2+1
	%             hmax(N/2) = vub(1)
	%             hmin(N/2) = vlb(1)
	% For type 2: hmax((N+1)/2-m) = vub(m) m = 1,...,(N+1)/2
	%             hmin((N+1)/2-m) = vlb(m) m = 1,...,(N+1)/2
	
	% 	The coefficient space is definied by the bounds vlb and vub, 
	%	which also contains coefficient sets that does not met 
	%	the specification.
	
	% vlb0 and vub0 limits the problem.
	% ind index the limiting parameters and val its limits.
	
	% Example [vlb,vub,h0, hlb,hub] = BOUNDING_BOX_FIR(15,[0.2 0.5]*pi,[0.05 0.01],[],[])
	
	
	
	Kp = 100;     % Number of grid points in the passband  
	Ks = 100;     % Number of grid points in the stopband  
	% Checking type
	if mod(N,2) == 0   % Even order
		Ftype = 1;       % Type I
	    M = N/2+1;
	else  
		Ftype = 2;       % Type II
		M = (N+1)/2;
	end
	vlb = -inf*ones(1,M); % Initial bounds
	vub = inf*ones(1,M);
	m = 1:M;
	%	Solve the initial design problem
	[h0,xinit] = SOLVE_LP(N,linspace(0,W0(1),Kp),...
	linspace(W0(2),pi,Ks),delta(1),delta(2),vlb,vub); 
	xinit = xinit(1:M);
	wt = [linspace(0,W0(1),Kp) linspace(W0(2),pi,Ks)];
	% 	Limit the coefficient space by in turn finding min 
	%	and max of each coefficient.
	for index = 1:M  
		if ~isempty(ind)
			if isempty(find(index == ind))		
				b = [ones(1,Kp)+delta(1) delta(2)*ones(1,Ks)...
				-1*ones(1,Kp)+delta(1) delta(2)*ones(1,Ks)]';
				A = [TRIGMAT(Ftype,m,wt)];
				A = [A' -TRIGMAT(Ftype,m,wt)']';
				c = zeros(1,M);
				c(index) = 1;  % minimize
				if New == 1
					x = linprog(c,A,b,[],[],vlb,vub,xinit);
				else
					x = lp(c,A,b,vlb,vub,xinit);
				end
				vlb(index) = x(index);
				c(index) = -1; % maximixe
				if New == 1
					x = linprog(c,A,b,[],[],vlb,vub,xinit);
				else	
					x = lp(c,A,b,vlb,vub,xinit);
				end
				vub(index) = x(index);
				show = [vlb' vub'];
				disp(show)
			else
				vlb(index) = val(find(index == ind));
				vub(index) = val(find(index == ind));
			end % if
		else
			b = [ones(1,Kp)+delta(1) delta(2)*ones(1,Ks)...
			-1*ones(1,Kp)+delta(1) delta(2)*ones(1,Ks)]';
			A = [TRIGMAT(Ftype,m,wt)];
			A = [A' -TRIGMAT(Ftype,m,wt)']';
			c = zeros(1,M);
			c(index) = 1;  % minimize
			if New == 1	
                %linproglp(c,A,b,[],[],vlb,vub,xinit);	
				x = linprog(c,A,b,[],[],vlb,vub,xinit);	
			else
				x = lp(c,A,b,vlb,vub,xinit);
			end
			vlb(index) = x(index);
			c(index) = -1; % maximixe
			if New == 1
				x = linprog(c,A,b,[],[],vlb,vub,xinit);
			else
				x = lp(c,A,b,vlb,vub,xinit);
			end
			vub(index) = x(index);
			%show = [vlb' vub'];
			%disp(show)
		end % if
	
	end %for
	if mod(N,2) == 0   % Even order
		hub = [0.5*fliplr(vub(2:M)) vub(1) 0.5*vub(2:M)];
		hlb = [0.5*fliplr(vlb(2:M)) vlb(1) 0.5*vlb(2:M)];
	else  
		hub = [0.5*fliplr(vub(1:M)) 0.5*vub(1:M)];
		hlb = [0.5*fliplr(vlb(1:M)) 0.5*vlb(1:M)];
	end



	
